#!/bin/bash
#
# Copyright (c) 2015 by Cisco Systems, Inc.
#
# Name        : post_upgrade.sh
# BUILD_TIME  : VSMS_release
# Description : Script to run after upgrade of VSM rpms.
# Input       : /tmp/restart_after_upgrade script which is saved by the preupgrade script
# Action      : restores system activities after upgrade
# Output :      none


RESTART_AFTER_UPGRADE=/tmp/restart_after_upgrade 
LOG_PRE_UPG_KERNEL=/usr/BWhttpd/upgrade/server/pre-upgrade-kernel-ver
LOG_POST_UPG_KERNEL=/usr/BWhttpd/upgrade/server/post-upgrade-kernel-ver

RC=0

function LOG {
    #local dest_log=$1
    local msg=$1

    local log_prefix
    local log_date
    local output

    log_date=$(date +"%F %T")
    log_prefix="$log_date.??? [ $(basename $0)($$) ] "

    output=$(echo "$msg" | sed -e "s/^/$log_prefix/g" \
                               -e "s/\\\n/\\\n$log_prefix/g")

    printf "$output\n" #>> $dest_log 
}

function copy_dev_onvif {
    LOG "Changing permision of folder /usr/BWhttpd/conf/devices to 777"
    chmod 0777 /usr/BWhttpd/conf/devices
    LOG "Post upgrade : Copying old onvif dev xml"
    VAR_DEV_ONVIF=/var/onvif
    mkdir -p $VAR_DEV_ONVIF
    touch $VAR_DEV_ONVIF/temp_empty.xml
    cp -p $VAR_DEV_ONVIF/*.xml /usr/BWhttpd/conf/devices/
    rm $VAR_DEV_ONVIF/temp_empty.xml
    rm /usr/BWhttpd/conf/devices/temp_empty.xml
    LOG "Post upgrade : Copying old dev xml completed"
}

function copy_openssl_cnf {
   
   echo "Post upgrade : Copying old opensslAllowedCipher.cnf"
   CONFDIR=/usr/BWhttpd/conf
   OPENSSL_CONF=/tmp/opensslAllowedCipher.cnf
   if [  -e $OPENSSL_CONF ]
       then
       cp -p -rf $OPENSSL_CONF $CONFDIR
       echo "Post upgrade : Copying old opensslAllowedCipher.cnf completed"
   else
       echo "Post upgrade : Old opensslAllowedCipher.cnf not present in $CONFDIR"
   fi      
}

function copy_failover_cnf {
   
   echo "Post upgrade : Copying old failoverconf.txt"
   CONFDIR=/usr/BWhttpd/conf
   FAILOVER_CONF=/tmp/failoverconf.txt
   if [  -e $FAILOVER_CONF ]
       then
       cp -p -rf $FAILOVER_CONF $CONFDIR
       echo "Post upgrade : Copying old failoverconf.txt commpleted"
   else
       echo "Post upgrade : Old failoverconf.txt not present in $CONFDIR"
   fi 
}    
 
# To copy ntp config
function copy_ntp_conf()
{
        echo "Post upgrade : Checking & adding to ntp.conf"
        FILE="/etc/ntp.conf"
        STRING1="restrict default kod nomodify notrap nopeer noquery"
        STRING2="restrict -6 default kod nomodify notrap nopeer noquery"

        if grep -q "$STRING1" "$FILE"
        then
                echo "Config already available - \"$STRING1\""
        else
                echo "Adding config - \"$STRING1\""
                sudo sh -c "echo "" >> $FILE"
                sudo sh -c "echo $STRING1 >> $FILE"
        fi

        if grep -q "$STRING2" "$FILE"
        then
                echo "Config already available - \"$STRING2\""
        else
                echo "Adding config - \"$STRING2\""
                sudo sh -c "echo "" >> $FILE"
                sudo sh -c "echo $STRING2 >> $FILE"
        fi
        echo "Post upgrade : Modification ntp.conf completed"
        sudo service ntpd restart
}


rpm -qa | grep kernel > $LOG_POST_UPG_KERNEL
LOG "Post upgrade kernel is $(< $LOG_POST_UPG_KERNEL)"
copy_dev_onvif
copy_openssl_cnf
copy_failover_cnf
copy_ntp_conf

# After upgrade softlink to MegaCli is missing - BEMS914335 - CSCvo29635
ln -sf /opt/MegaRAID/MegaCli/MegaCli64 /opt/MegaRAID/MegaCli/MegaCli

diff $LOG_PRE_UPG_KERNEL $LOG_POST_UPG_KERNEL > /dev/null
if [ $? -eq 1 ]
then
    echo "REBOOT REQUIRED." 
    LOG "Reboot required due to kernel change post upgrade"
    RC=86
else
    [[ -e $RESTART_AFTER_UPGRADE ]]  && $RESTART_AFTER_UPGRADE && RC=$?
fi
LOG "Return code from post_upgrade.sh $RC"
exit $RC

